/****************************************************************
GestureTest.ino
APDS-9960 RGB and Gesture Sensor
Shawn Hymel @ SparkFun Electronics
May 30, 2014
https://github.com/sparkfun/APDS-9960_RGB_and_Gesture_Sensor

Tests the gesture sensing abilities of the APDS-9960. Configures
APDS-9960 over I2C and waits for gesture events. Calculates the
direction of the swipe (up, down, left, right) and displays it
on a serial console. 

To perform a NEAR gesture, hold your hand
far above the sensor and move it close to the sensor (within 2
inches). Hold your hand there for at least 1 second and move it
away.

To perform a FAR gesture, hold your hand within 2 inches of the
sensor for at least 1 second and then move it above (out of
range) of the sensor.

Hardware Connections:

IMPORTANT: The APDS-9960 can only accept 3.3V!
 
 wemos D1 mini Pin  APDS-9960 Board  Function
 
 3.3V         VCC              Power
 GND          GND              Ground
 D2           SDA              I2C Data
 D1           SCL              I2C Clock
 D6           INT              Interrupt

Resources:
Include Wire.h and SparkFun_APDS-9960.h

Development environment specifics:
Written in Arduino 1.0.5
Tested with SparkFun Arduino Pro Mini 3.3V

This code is beerware; if you see me (or any other SparkFun 
employee) at the local, and you've found our code helpful, please
buy us a round!

Distributed as-is; no warranty is given.

Modified for ESP8266 by Jon Ulmer Nov 2016 then adapted by dgemily Dec 2020 for the new ESP8266 library

Modified:
- added wire.begin to configure pin
- Interrupt callback functions in IRAM (required for the new ESP8266 libary) by dgemily Dec 2020
- use digitalPinToInterrupt(GPIO) in attachInterrupt and detachInterrupt by dgemily Dec 2020
- use GPIO number by dgemily Dec 2020

****************************************************************/

#include <Wire.h>
#include <SparkFun_APDS9960.h>

#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

// Pins on wemos D1 mini
#define APDS9960_SDA    4  //GPIO4 (D2)
#define APDS9960_SCL    5  //GPIO5 (D1)
// Constants
const byte APDS9960_INT  = 12; //GPIO12 (D6)



///oled
#define SCREEN_WIDTH 128    // OLED display width, in pixels
#define SCREEN_HEIGHT 64    // OLED display height, in pixels
#define OLED_RESET -1        // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

#define LOGO_HEIGHT   64
#define LOGO_WIDTH    64
static const unsigned char PROGMEM myleft[] =
{ 
  0x45, 0x45, 0x45, 0xff,   /*Color of index 0*/
  0xe9, 0xea, 0xe9, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 
  0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xf8, 0x1f, 
  0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xfc, 0x0f, 
  0xff, 0xff, 0xff, 0x87, 0xff, 0xff, 0xfc, 0x0f, 
  0xff, 0xff, 0xff, 0x07, 0xff, 0xff, 0xfe, 0x0f, 
  0xff, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xfe, 0x07, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xfe, 0x07, 
  0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xfe, 0x07, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0xfe, 0x07, 
  0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0xfe, 0x03, 
  0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xfe, 0x03, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xfe, 0x07, 
  0xff, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xfe, 0x07, 
  0xff, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xfc, 0x07, 
  0xff, 0xff, 0xff, 0x87, 0xff, 0xff, 0xfc, 0x07, 
  0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xfc, 0x07, 
  0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xf8, 0x0f, 
  0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xf8, 0x0f, 
  0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 
  0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 
  0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 
  0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x3f, 
  0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0x80, 0x7f, 
  0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 
  0xff, 0x7c, 0x7f, 0xff, 0xff, 0xfe, 0x00, 0xff, 
  0xff, 0xbe, 0x1f, 0xff, 0xff, 0xf8, 0x01, 0xff, 
  0xff, 0xdf, 0x0f, 0xff, 0xff, 0xf0, 0x01, 0xff, 
  0xff, 0xe0, 0x03, 0xff, 0xff, 0xc0, 0x03, 0xff, 
  0xff, 0xf0, 0x00, 0x7f, 0xfe, 0x00, 0x07, 0xff, 
  0xff, 0xf8, 0x00, 0x03, 0xc0, 0x00, 0x0f, 0xff, 
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 
  0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x01, 0xff, 0xff, 
  0xff, 0xff, 0xc0, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x0f, 0xff, 0xff, 
  0xff, 0xff, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
static const unsigned char PROGMEM myright[] =
{ 0x33, 0x34, 0x33, 0xff,   /*Color of index 0*/
  0xec, 0xed, 0xec, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xff, 0xff, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x0f, 0xff, 0xff, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0xff, 0xff, 
  0xff, 0xfe, 0x00, 0x0f, 0xf0, 0x00, 0x7f, 0xff, 
  0xff, 0xfc, 0x00, 0xff, 0xff, 0x00, 0x1f, 0xff, 
  0xff, 0xf8, 0x03, 0xff, 0xff, 0xc6, 0x0f, 0xff, 
  0xff, 0xf0, 0x0f, 0xff, 0xff, 0xf0, 0x07, 0xff, 
  0xff, 0xe0, 0x1f, 0xff, 0xff, 0xfc, 0x03, 0xff, 
  0xff, 0xc0, 0x3f, 0xff, 0xff, 0xfe, 0x01, 0xff, 
  0xff, 0x80, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 
  0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0x80, 0x7f, 
  0xff, 0x03, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x7f, 
  0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x3f, 
  0xfc, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3f, 
  0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1f, 
  0xf8, 0x0f, 0xff, 0xff, 0xef, 0xff, 0xf8, 0x1f, 
  0xf8, 0x1f, 0xff, 0xff, 0xe7, 0xff, 0xf8, 0x0f, 
  0xf0, 0x3f, 0xff, 0xff, 0xe3, 0xff, 0xfc, 0x0f, 
  0xf0, 0x3f, 0xff, 0xff, 0xe1, 0xff, 0xfc, 0x07, 
  0xf0, 0x3f, 0xff, 0xff, 0xe0, 0xff, 0xfc, 0x07, 
  0xf0, 0x7f, 0xff, 0xff, 0xe0, 0x3f, 0xfe, 0x07, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x07, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x03, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x01, 0xff, 0x03, 
  0xe0, 0xff, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x03, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x03, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x03, 
  0xe0, 0x7f, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x03, 
  0xe0, 0x7f, 0xff, 0xff, 0xe0, 0x7f, 0xfe, 0x03, 
  0xe0, 0x3f, 0xff, 0xff, 0xe0, 0xff, 0xfc, 0x07, 
  0xe0, 0x3f, 0xff, 0xff, 0xe1, 0xff, 0xfc, 0x07, 
  0xf0, 0x1f, 0xff, 0xff, 0xe3, 0xff, 0xf8, 0x07, 
  0xf0, 0x1f, 0xff, 0xff, 0xe7, 0xff, 0xf8, 0x07, 
  0xf0, 0x0f, 0xff, 0xff, 0xef, 0xff, 0xf0, 0x0f, 
  0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0f, 
  0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 
  0xfc, 0x83, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x1f, 
  0xfc, 0x41, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x3f, 
  0xfe, 0x80, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3f, 
  0xfe, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x7f, 
  0xff, 0x00, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0xff, 
  0xff, 0x80, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0xff, 
  0xff, 0xc0, 0x07, 0xff, 0xff, 0xe0, 0x01, 0xff, 
  0xff, 0xe0, 0x01, 0xff, 0xff, 0x80, 0x03, 0xff, 
  0xff, 0xf0, 0x00, 0x3f, 0xfc, 0x00, 0x07, 0xff, 
  0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 
  0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0xff, 0xff, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x0f, 0xff, 0xff, 
  0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
 
static const unsigned char PROGMEM myup[] =
{ 0x2d, 0x2d, 0x2d, 0xff,   /*Color of index 0*/
  0xf5, 0xf6, 0xf5, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xfe, 0x00, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xff, 0xff, 
  0xff, 0xff, 0xc0, 0x00, 0x00, 0x0f, 0xff, 0xff, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
  0xff, 0xf8, 0x00, 0x7f, 0xf8, 0x00, 0x7f, 0xff, 
  0xff, 0xf0, 0x03, 0xff, 0xff, 0x00, 0x3f, 0xff, 
  0xff, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x1f, 0xff, 
  0xff, 0x80, 0x3f, 0xff, 0xff, 0xf0, 0x07, 0xff, 
  0xff, 0x80, 0x7f, 0xff, 0xff, 0xf8, 0x03, 0xff, 
  0xff, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff, 
  0xfe, 0x01, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xff, 
  0xfc, 0x03, 0xff, 0xfc, 0xff, 0xff, 0x00, 0xff, 
  0xfc, 0x07, 0xff, 0xf8, 0x7f, 0xff, 0x80, 0xff, 
  0xf8, 0x0f, 0xff, 0xf0, 0x3f, 0xff, 0xc0, 0x7f, 
  0xf0, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x3f, 
  0xf0, 0x1f, 0xff, 0xe0, 0x1f, 0xff, 0xe0, 0x3f, 
  0xe0, 0x3f, 0xff, 0xc0, 0x0f, 0xff, 0xf0, 0x1f, 
  0xe0, 0x3f, 0xff, 0x80, 0x07, 0xff, 0xf0, 0x1f, 
  0xe0, 0x7f, 0xff, 0x00, 0x03, 0xff, 0xf8, 0x1f, 
  0xc0, 0x7f, 0xfe, 0x00, 0x01, 0xff, 0xf8, 0x0f, 
  0xc0, 0x7f, 0xfc, 0x00, 0x00, 0xff, 0xf8, 0x0f, 
  0xc0, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xfc, 0x0f, 
  0xc0, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xfc, 0x0f, 
  0x80, 0xff, 0xe0, 0x00, 0x00, 0x1f, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0x80, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0xc0, 0xff, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x07, 
  0xc0, 0x7f, 0xff, 0x80, 0x07, 0xff, 0xf8, 0x0f, 
  0xc0, 0x7f, 0xff, 0x80, 0x07, 0xff, 0xf8, 0x0f, 
  0xc0, 0x7f, 0xff, 0x80, 0x07, 0xff, 0xf8, 0x0f, 
  0xe0, 0x3f, 0xff, 0x80, 0x07, 0xff, 0xf0, 0x1f, 
  0xe0, 0x3f, 0xff, 0x80, 0x07, 0xff, 0xf0, 0x1f, 
  0xe0, 0x1f, 0xff, 0x80, 0x07, 0xff, 0xe0, 0x1f, 
  0xf0, 0x0f, 0xff, 0x80, 0x07, 0xff, 0xc0, 0x3f, 
  0xf0, 0x0f, 0xff, 0x80, 0x07, 0xff, 0xc0, 0x3f, 
  0xf8, 0x07, 0xff, 0x80, 0x07, 0xff, 0x80, 0x7f, 
  0xf8, 0x03, 0xff, 0x80, 0x07, 0xff, 0x00, 0x7f, 
  0xfc, 0x01, 0xff, 0xff, 0xff, 0xfe, 0x00, 0xff, 
  0xfe, 0x00, 0xff, 0xff, 0xff, 0xfc, 0x01, 0xff, 
  0xfe, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x01, 0xff, 
  0xff, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x03, 0xff, 
  0xff, 0x80, 0x07, 0xff, 0xff, 0x80, 0x07, 0xff, 
  0xff, 0xc0, 0x00, 0xff, 0xfc, 0x00, 0x0f, 0xff, 
  0xff, 0xe0, 0x00, 0x0f, 0xc0, 0x00, 0x1f, 0xff, 
  0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 
  0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 
  0xff, 0xfe, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x07, 0xff, 0xff, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x1f, 0xff, 0xff, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
 
static const unsigned char PROGMEM mydown[] =
{ 0x3f, 0x3f, 0x3f, 0xff,   /*Color of index 0*/
  0xea, 0xeb, 0xea, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x1f, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x0f, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x07, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x7f, 
  0xff, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xc0, 0x7f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xe0, 0x3f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xf0, 0x1f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xf8, 0x1f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xf8, 0x0f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xfc, 0x0f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xfc, 0x0f, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xfe, 0x07, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xfe, 0x07, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xfe, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x0f, 0xff, 0x03, 
  0xff, 0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0x03, 
  0xff, 0xff, 0xfc, 0x00, 0x00, 0x1f, 0xff, 0x03, 
  0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xfe, 0x03, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xfe, 0x03, 
  0xf7, 0xff, 0xff, 0x80, 0x00, 0xff, 0xfe, 0x03, 
  0xff, 0xdf, 0xff, 0xc0, 0x01, 0xff, 0xfc, 0x07, 
  0xff, 0xdf, 0xff, 0xe0, 0x03, 0xff, 0xfc, 0x07, 
  0xfb, 0xef, 0xff, 0xf0, 0x07, 0xff, 0xf8, 0x07, 
  0xf9, 0xef, 0xff, 0xf8, 0x07, 0xff, 0xf8, 0x0f, 
  0xfd, 0xe7, 0xff, 0xfc, 0x0f, 0xff, 0xf0, 0x0f, 
  0xfc, 0x13, 0xff, 0xfc, 0x1f, 0xff, 0xe0, 0x1f, 
  0xfe, 0x01, 0xff, 0xfe, 0x3f, 0xff, 0xc0, 0x1f, 
  0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3f, 
  0xff, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x00, 0x3f, 
  0xff, 0x80, 0x3f, 0xff, 0xff, 0xfe, 0x00, 0x7f, 
  0xff, 0x80, 0x1f, 0xff, 0xff, 0xfc, 0x00, 0xff, 
  0xff, 0xc0, 0x07, 0xff, 0xff, 0xf0, 0x01, 0xff, 
  0xff, 0xe0, 0x01, 0xff, 0xff, 0xc0, 0x01, 0xff, 
  0xff, 0xf0, 0x00, 0x7f, 0xff, 0x00, 0x03, 0xff, 
  0xff, 0xf8, 0x00, 0x03, 0xe0, 0x00, 0x07, 0xff, 
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 
  0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 
  0xff, 0xff, 0xe0, 0x00, 0x00, 0x01, 0xff, 0xff, 
  0xff, 0xff, 0xf8, 0x00, 0x00, 0x07, 0xff, 0xff, 
  0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
static const unsigned char PROGMEM mynear[] =
{ 0x59, 0x59, 0x59, 0xff,   /*Color of index 0*/
  0xf8, 0xf9, 0xf8, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe7, 0xef, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe3, 0xcf, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe1, 0x8f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xf7, 0xff, 0x80, 0x01, 0xff, 0xef, 0xff, 
  0xff, 0xf3, 0xff, 0x00, 0x00, 0xff, 0xcf, 0xff, 
  0xff, 0xf1, 0xfe, 0x00, 0x00, 0x7f, 0x8f, 0xff, 
  0xff, 0xf0, 0xfe, 0x00, 0x00, 0x3f, 0x0f, 0xff, 
  0xc0, 0x00, 0x7c, 0x00, 0x00, 0x3e, 0x00, 0x03, 
  0xc0, 0x00, 0x3c, 0x00, 0x00, 0x1c, 0x00, 0x03, 
  0xe0, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x0f, 
  0xf0, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x1f, 
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
  0xf8, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x1f, 
  0xf0, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 0x0f, 
  0xe0, 0x00, 0x38, 0x00, 0x00, 0x18, 0x00, 0x07, 
  0xc0, 0x00, 0x7c, 0x00, 0x00, 0x1c, 0x00, 0x03, 
  0xff, 0xf0, 0xfc, 0x00, 0x00, 0x3e, 0x0f, 0xff, 
  0xff, 0xf1, 0xfc, 0x00, 0x00, 0x3f, 0x0f, 0xff, 
  0xff, 0xf3, 0xfe, 0x00, 0x00, 0x7f, 0x8f, 0xff, 
  0xff, 0xf7, 0xff, 0x00, 0x00, 0xff, 0xcf, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe1, 0x8f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe3, 0xcf, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe7, 0xef, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
 
static const unsigned char PROGMEM myfar[] =
{ 0x63, 0x64, 0x63, 0xff,   /*Color of index 0*/
  0xf8, 0xfa, 0xf8, 0xff,   /*Color of index 1*/
 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe1, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe3, 0x8f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe7, 0xcf, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xef, 0xef, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xbf, 0xff, 0x00, 0x00, 0xff, 0xfd, 0xff, 
  0xff, 0x3f, 0xfe, 0x00, 0x00, 0x7f, 0xfc, 0xff, 
  0xfe, 0x3f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x7f, 
  0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x1f, 
  0xf0, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x0f, 
  0xe0, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x07, 
  0xc0, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x03, 
  0x80, 0x00, 0x78, 0x00, 0x00, 0x1e, 0x00, 0x01, 
  0xc0, 0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x03, 
  0xe0, 0x00, 0x18, 0x00, 0x00, 0x18, 0x00, 0x07, 
  0xf0, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x0f, 
  0xf8, 0x00, 0x0c, 0x00, 0x00, 0x30, 0x00, 0x1f, 
  0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 
  0xfe, 0x3f, 0xfe, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 
  0xff, 0x3f, 0xff, 0x00, 0x00, 0x7f, 0xfc, 0xff, 
  0xff, 0xbf, 0xff, 0x00, 0x00, 0xff, 0xfd, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf7, 0xe7, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf3, 0xc7, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf1, 0x87, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf0, 0x0f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
};
 
 
 

// Global Variables
SparkFun_APDS9960 apds = SparkFun_APDS9960();
volatile bool isr_flag = 0;

//Interrupt callback function in IRAM
void ICACHE_RAM_ATTR interruptRoutine ();

void setup() {
   //Start I2C with pins defined above
  Wire.begin(APDS9960_SDA,APDS9960_SCL);

  // Set interrupt pin as input
  pinMode(digitalPinToInterrupt(APDS9960_INT), INPUT);
  //delay(250);
  // Initialize Serial port
  Serial.begin(9600);
  Serial.println();
  Serial.println(F("--------------------------------"));
  Serial.println(F("SparkFun APDS-9960 - GestureTest"));
  Serial.println(F("--------------------------------"));

  display.begin(SSD1306_SWITCHCAPVCC, 0x3C); //initialize with the I2C addr 0x3C (128x64)

  
  // Initialize interrupt service routine
  attachInterrupt(digitalPinToInterrupt(APDS9960_INT), interruptRoutine, FALLING);

  // Initialize APDS-9960 (configure I2C and initial values)
  if ( apds.init() ) {
    Serial.println(F("APDS-9960 initialization complete"));
    display.clearDisplay();
    display.setCursor(0,0);  
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.println("ADPS Initialization");
    display.println("");
    display.setTextSize(2);
    display.println("Success! ");
    display.display();
  } else {
    Serial.println(F("Something went wrong during APDS-9960 init!"));
    display.clearDisplay();
    display.setCursor(0,0);  
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.println("ADPS Initialization");
    display.println("");
    display.setTextSize(2);
    display.println("Failed! ");
    display.display();
  }
  
  // Start running the APDS-9960 gesture sensor engine
  if ( apds.enableGestureSensor(true) ) {
    Serial.println(F("Gesture sensor is now running"));
    display.clearDisplay();
    display.setCursor(0,0);  
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.println("ADPS Initialization");
    display.println("");
    display.setTextSize(2);
    display.println("Success! ");
    display.display();
  } else {
    Serial.println(F("Something went wrong during gesture sensor init!"));
    display.clearDisplay();
    display.setCursor(0,0);  
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.println("ADPS Initialization");
    display.println("");
    display.setTextSize(2);
    display.println("Failed! ");
    display.display();
  }
}

void loop() {
  if( isr_flag == 1 ) {
    detachInterrupt(digitalPinToInterrupt(APDS9960_INT));
    handleGesture();    
    isr_flag = 0;
    attachInterrupt(digitalPinToInterrupt(APDS9960_INT), interruptRoutine, FALLING);
  }
}

void interruptRoutine() {
  isr_flag = 1;
}

void handleGesture() {
    if ( apds.isGestureAvailable() ) {
    switch ( apds.readGesture() ) {
      case DIR_UP:
        Serial.println("UP");
        display.clearDisplay();
        display.drawBitmap(31, 0, myup, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      case DIR_DOWN:
        Serial.println("DOWN");
        display.clearDisplay();
        display.drawBitmap(31, 0, mydown, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      case DIR_LEFT:
        Serial.println("LEFT");
        display.clearDisplay();
        display.drawBitmap(31, 0, myleft, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      case DIR_RIGHT:
        Serial.println("RIGHT");
        display.clearDisplay();
        display.drawBitmap(31, 0, myright, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      case DIR_NEAR:
        Serial.println("NEAR");
        display.clearDisplay();
        display.drawBitmap(31, 0, mynear, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      case DIR_FAR:
        Serial.println("FAR");
        display.clearDisplay();
        display.drawBitmap(31, 0, myfar, LOGO_WIDTH, LOGO_HEIGHT, 1);
        display.display();
        break;
      default:
        Serial.println("NONE");
    }
  }
 
}
